/* Copyright (C) 2015-2018 RealVNC Ltd.  All Rights Reserved.
 */

#include <vnccommon/Mutex.h>

using namespace vnccommon;

Mutex::Mutex()
{
    create(false);
}

Mutex::Mutex(bool recursive)
{
    create(recursive);
}

Mutex::~Mutex()
{
    pthread_mutex_destroy(&mMutex);
}

void Mutex::create(bool recursive)
{
    pthread_mutexattr_t attr;
    pthread_mutexattr_init(&attr);

    if (recursive)
    {
      pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
    }

    const int result = pthread_mutex_init(&mMutex, &attr);
    if (result != 0)
    {
        throw MutexException("pthread_mutex_init failed");
    }
}

void Mutex::internalLock()
{
    if(pthread_mutex_lock(&mMutex))
    {
        throw MutexException("pthread_mutex_lock failed");
    }
}

void Mutex::internalUnlock()
{
    if(pthread_mutex_unlock(&mMutex))
    {
        throw MutexException("pthread_mutex_unlock failed");
    }
}

